// Copyright 2005, Vela Design Group.  All rights reserved.

var placeTimes = new Array();

var infoHeight = 99;
var widgetWidth = 276;
var backsideHeight = 315;

var currentSelection = null;
var showingInfo = true;
var infoMode = 'sun';
var showAMPM = true;

var isShowingFront = true;
var backsideChanged = false;


//pref keys
var selectionPrefKey = "selection";
var showAMPMPrefKey = "showAMPM";
var infoModePrefKey = "infoMode";
var regionPrefKey = "region";
var placePrefKey = "place";

var maxItems = 16;


function getLocalizedString (key)
{
	try {
		var ret = localizedStrings[key];
		if (ret === undefined)
			ret = key;
		return ret;
	} catch (ex) {}

	return key;
}

//
//	update functions
//

var validMode = true;
var demoMode = true;

//pre-fetch images
(new Image()).src = "Images/digTime12_1.png";
(new Image()).src = "Images/digTime12_5.png";
(new Image()).src = "Images/digTime24_1.png";
(new Image()).src = "Images/digTime24_5.png";

(new Image()).src = "Images/light1.png";
(new Image()).src = "Images/light2.png";
(new Image()).src = "Images/light3.png";
(new Image()).src = "Images/light4.png";
(new Image()).src = "Images/light5.png";

function getEarthLightImage(earthLight)
{		
	var imageSrc;
	
	switch (earthLight) {
		case 1:
			imageSrc = "Images/light1.png";
			break;
		case 2:
			imageSrc = "Images/light2.png";
			break;
		case 3:
			imageSrc = "Images/light3.png";
			break;
		case 4:
			imageSrc = "Images/light4.png";
			break;
		default: //night
			imageSrc = "Images/light5.png";
	}
	
	return imageSrc;
}

function updateNow()
{
	if (window.VTPlugin && isShowingFront && validMode) {
		
		//alert("  js-updateNow");

		var header = document.getElementById('placesHeader');

		var count = placeTimes.length;
  		for (var index = 0; index < count; ++index)
  		{
  			try 
  			{
				var placeTimeID =  placeTimes[index];
				var placeSpan = document.getElementById(placeTimeID+"_place");
				
				//position dependent code (firstChild)?
				
				placeSpan.firstChild.data = VTPlugin.infoStringForRow(0, index) + " ";
				
				var time24Span = document.getElementById(placeTimeID+"_time24");
				var time12Span = document.getElementById(placeTimeID+"_time12");
				var timeAMPMSpan = document.getElementById(placeTimeID+"_timeAMPM");
				
				var timeInfo = VTPlugin.timeInfoForRow(index);
				time24Span.firstChild.data = timeInfo[0];
				time12Span.firstChild.data = timeInfo[1];
				timeAMPMSpan.firstChild.data = timeInfo[2];

				var row = header.childNodes[index];
				
				var savedEarthLight = row.earthLight;
				var earthLight = VTPlugin.earthLightKindForRow(index);
				
				if (earthLight != savedEarthLight) {
					row.setAttribute ("earthLight", earthLight);

					//set background image for digital time
					var lightBox = document[placeTimeID+"_light"];
					lightBox.src = getEarthLightImage(earthLight);
					
					if (earthLight == 1 || earthLight == 5)
						lightBox.setAttribute ("style", "visibility:hidden;");
					else
						lightBox.setAttribute ("style", "visibility:visible;");

					//set color of digital time text
					var digTimeBackground = document[placeTimeID+"_digTimeBack"];
					if (earthLight == 1) {
						if (showAMPM)
							digTimeBackground.src = "Images/digTime12_1.png";
						else
							digTimeBackground.src = "Images/digTime24_1.png";
		
						time24Span.setAttribute ("class", "digTime24 digDay");
						time12Span.setAttribute ("class", "digTime12 digDay");
						timeAMPMSpan.setAttribute ("class", "digTimeAMPM digDay");
					} else {
						if (showAMPM)
							digTimeBackground.src = "Images/digTime12_5.png";
						else
							digTimeBackground.src = "Images/digTime24_5.png";

						time24Span.setAttribute ("class", "digTime24 digNight");
						time12Span.setAttribute ("class", "digTime12 digNight");
						timeAMPMSpan.setAttribute ("class", "digTimeAMPM digNight");
					}
					
					if (showAMPM)
						digTimeBackground.setAttribute("style", "left: 177px;");
					else
						digTimeBackground.setAttribute("style", "left: 195px;");
				}

			} catch (ex)
			{
				// don't let one exception lose all the data
			}
		}

		updateInfo();
	}
}


//	Love love love
//	You better hope love is the answer baby
//	I think you better hope it comes before the summer
//	- Jimi Hendrix

var clockHandHours = new Image (4, 24);
clockHandHours.src = 'Images/clockHandHours.png';

var clockHandMinutes = new Image (2, 30);
clockHandMinutes.src = 'Images/clockHandMinutes.png';

var clockHandSeconds = new Image (3, 49);
clockHandSeconds.src = 'Images/clockHandSeconds.png';

function drawClockHands(secondsAngle, minutesAngle, hoursAngle)
{
	var canvas = document.getElementById("clock-canvas");
	var context = canvas.getContext("2d");
	
	context.clearRect (0, 0, 90, 90);

	context.save();
	context.translate (90/2, 90/2);

	//hours
	context.save();
	context.rotate (hoursAngle);
	context.translate (-2.0, -22.0);
	context.drawImage (clockHandHours, 0, 0, 4, 24);
	context.restore();
	
	//minutes
	context.save();
	context.rotate (minutesAngle);
	context.translate (-1.0, -28.0);
	context.drawImage (clockHandMinutes, 0, 0, 2, 30);
	context.restore();

	//seconds
	context.rotate (secondsAngle);
	context.translate (-1.5, -35.0);
	context.drawImage (clockHandSeconds, 0, 0, 4, 49);

	context.restore();
}

function updateSeconds(secondsAngle, minutesAngle, hoursAngle, timeInfo) //timeEuro, timeAMPM
{
	if (window.VTPlugin) {
		
		if (showingInfo && infoMode == 'time') {
			drawClockHands(secondsAngle, minutesAngle, hoursAngle);
			document.getElementById("localTimeSeconds").innerText = timeInfo[0];
			if (showAMPM) {
				document.getElementById("localTime").innerText = timeInfo[2];
				document.getElementById("localTimeAMPM").innerText = timeInfo[3];
			} else {
				document.getElementById("localTime").innerText = timeInfo[1];
				document.getElementById("localTimeAMPM").innerText = "";
			}
		}
	}
}

function createRow (rowIndex)
{
	var placeTimeID =  placeTimes[rowIndex];
	
	var row = document.createElement('div');
	
	row.setAttribute ("class", "placeTitle");
	row.setAttribute ("onclick", "clickonrow(event, this);");

	//addClock MUST be called before this code (to initialize placeTimes).
	row.setAttribute ("placeTimeID", placeTimeID);
	//alert("createRow: placeTimeID = " + placeTimeID + " " + VTPlugin.infoStringForRow(0, rowIndex));

	row.setAttribute ("earthLight", "-1");
	
	var flagImage = document.createElement('img');
	flagImage.setAttribute ("class", "flag");
	var flagInfo = VTPlugin.flagInfoForRow(rowIndex);
	flagImage.src = flagInfo[0];		
	flagImage.setAttribute ("style", "padding-top:" + flagInfo[1]);
	row.appendChild (flagImage);
	
	var placeSpan = document.createElement('span');
	placeSpan.setAttribute ("class", "place");
	placeSpan.setAttribute ("id", placeTimeID + "_place");
	placeSpan.innerText = " ";
	row.appendChild (placeSpan);
	
	var digTimeBgImage = document.createElement('img');
	digTimeBgImage.setAttribute ("class", "digTimeBg");
	digTimeBgImage.setAttribute ("id", placeTimeID + "_digTimeBack");
	digTimeBgImage.setAttribute ("onclick", "clickonTime(event, this);");
	row.appendChild (digTimeBgImage);
	
	var lightImage = document.createElement('img');
	lightImage.setAttribute ("class", "light");
	lightImage.setAttribute ("id", placeTimeID + "_light");
	lightImage.setAttribute ("onclick", "clickonTime(event, this);");
	lightImage.src = getEarthLightImage(2); //twilight is default
	lightImage.setAttribute ("style", "visibility:hidden;"); //hidden is default
	row.appendChild (lightImage);

	//time24
	var time24Span = document.createElement('span');
	time24Span.setAttribute ("class", "digTime24 digDay");
	time24Span.setAttribute ("id", placeTimeID + "_time24");
	time24Span.setAttribute ("onclick", "clickonTime(event, this);");
	time24Span.innerText = "23:59 PM";
	if (showAMPM)
		time24Span.setAttribute ("style", "display:none;");
	row.appendChild (time24Span);

	//time12
	var time12Span = document.createElement('span');
	time12Span.setAttribute ("class", "digTime12 digDay");
	time12Span.setAttribute ("id", placeTimeID + "_time12");
	time12Span.setAttribute ("onclick", "clickonTime(event, this);");
	time12Span.innerText = "11:59 PM";
	if (!showAMPM)
		time12Span.setAttribute ("style", "display:none;");
	row.appendChild (time12Span);
	
	//timeAMPM
	var timeAMPMSpan = document.createElement('span');
	timeAMPMSpan.setAttribute ("class", "digTimeAMPM digDay");
	timeAMPMSpan.setAttribute ("id", placeTimeID + "_timeAMPM");
	timeAMPMSpan.setAttribute ("onclick", "clickonTime(event, this);");
	timeAMPMSpan.innerText = "AM";
	if (!showAMPM)
		timeAMPMSpan.setAttribute ("style", "display:none;");
	row.appendChild (timeAMPMSpan);

	return row;
}

function edit_mouseover(event)
{
	event.target.src = "Images/edit-rollover.png";
}

function edit_mouseout (event)
{
	event.target.src = "Images/edit.png";
}

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

//pre-fetch images
(new Image()).src = "Images/backside1.png";
(new Image()).src = "Images/backside2.png";

var curBacksideItem = 1;
var resizedWhenFlippedOver = false;

function showbackside(event) {
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	curBacksideItem = 1;
	//document.getElementById ('content-backsideMenu').options[curBacksideItem].selected = true;
	changeBacksideContent();

	//alert("showbackside: widgetHeight = " + calculateWidgetHeight());
	
/*
	resizedWhenFlippedOver = true;
	if (window.widget)
	{
		widget.prepareForTransition("ToBack");
		//resize after flip
		window.resizeTo (widgetWidth, backsideHeight); //450 323
	}
*/
	resizedWhenFlippedOver = false;
	if (window.widget)
	{
		if (calculateWidgetHeight() < backsideHeight)
		{
			window.resizeTo (widgetWidth, backsideHeight);
			resizedWhenFlippedOver = true;
		}
		widget.prepareForTransition("ToBack");
	}
	front.style.display="none";
	back.style.display="block";
	isShowingFront = false;
	
	var regTitle = document.getElementById("regTitle");
	var regDesc1 = document.getElementById("regDesc1");
	var regDesc2 = document.getElementById("regDesc2");
	var regDesc3 = document.getElementById("regDesc3");

	if (demoMode) {
		regTitle.innerText = "Not Registered"
		regDesc1.innerText = "Click on the Purchase button below to purchase or enter a serial number."
		regDesc2.innerText = "Purchase VelaClock today to gain full access to all of the available cities and unlock the moon phase feature."
		regDesc3.innerText = "If you have already registered, you will need to close and re-open this widget."
	} else {
		regTitle.innerText = "Serial Number"
		regDesc1.innerText = VTPlugin.sNum();
		regDesc2.innerText = "";
		regDesc3.innerText = "";
	}

	enableAddButton();
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
	
	
	backsideChanged = false;
	
	document.removeEventListener("keypress", keyPressed, true);

	document.getElementById('fliprollie').style.display = 'none';

	event.stopPropagation();
	event.preventDefault();
}

function selectDone ()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	back.style.display="none";
	
	isShowingFront = true;
	
	if (window.widget) {
		setTimeout ('widget.performTransition();', 0);
	}
		
	if (backsideChanged)
	{
		// fix up widget
		var lastSelected = null;
		
		if (currentSelection != null)
			lastSelected = currentSelection.placeTimeID;
			
		setupMainTable (false);
		
		if (lastSelected != null)
		{
			var count = placeTimes.length;
			var found = false;
			for (var index = 0; index < count; ++index)
			{
				if (placeTimes[index] == lastSelected)
				{
					found = true;
					break;
				}
			}
			
			if (!found)
			{
				// the item we have selected is gone. select the first one
				clickonrowimp (document.getElementById('placesHeader').firstChild);
			}
			else
			{
				moveSelectionToPlaceID (lastSelected);
			}
		}
		
		if (window.VTPlugin)
			VTPlugin.savePlaceInfo(true);

	}
	
	updateNow(); //calls updateInfo

	//onshow();
	
	if (resizedWhenFlippedOver && window.widget)
	{
		var widgetHeight = calculateWidgetHeight();
		window.resizeTo(widgetWidth, widgetHeight);		
		//alert("selectDone: widgetHeight = " + calculateWidgetHeight());
		resizedWhenFlippedOver = false;
	}

	document.addEventListener("keypress", keyPressed, true);
}


//pre-fetch image
//(new Image()).src = "Images/selection_1.png";
//(new Image()).src = "Images/selection_X.png";
//(new Image()).src = "Images/selection_N.png";

function moveSelectionToPlaceID (placeTimeID)
{
	var index;
	var offset = 0; //1
	var count = placeTimes.length;
	for (index=0; index < count; ++index)
	{
		if (placeTimes[index] == placeTimeID)
			break;
	}
	if (index == count)
		index = 0;
	
	if (window.VTPlugin)
		VTPlugin.setSelectedRowForID(placeTimeID);

	switch (index)
	{
		case 0:
			selection.src = "Images/selection_1.png";
			offset = -1;
			break;
		case count - 1:
			selection.src = "Images/selection_N.png";
			offset = 1;
			break;
			
		default:
			selection.src = "Images/selection_X.png";
			break;
	}
	
	//the top border is about 6 pixels
	var offsetStr = (25*index + 6 + offset).toString();
	//alert("(" + placeTimeID + " index = " + index + ") off = " + offset + " tot = " + offsetStr);

	selection.style.top = offsetStr + "px";
	selection.style.display = "block";
	
	//CFS
	if (!showingInfo) {
		showingInfo = true;

		switch (infoMode)
		{
			case 'sun':
				showSunDiv();
				break;
			case 'moon':
				showMoonDiv();
				break;
			case 'time':
				showTimeDiv();
				break;
		}
	}
	updateInfo();
}

function clickonrowimp (row)
{
	currentSelection = row;

	moveSelectionToPlaceID (row.placeTimeID);
}


//pre-fetch image
(new Image()).src = "Images/borderBottomNoTabs.png";

function setupInfoAnimation (hiding)
{
	var infoDiv = document.getElementById('infoArea');
	var timeNow = (new Date).getTime();
	var multiplier = (event.shiftKey ? 10 : 1); // enable slo-mo
	var startingSize = parseInt(infoDiv.clientHeight,10);

	if (hiding) {
		//hide the tabs
		document.getElementById('sunButton').setAttribute ("style", "display:none;");
		document.getElementById('timeButton').setAttribute ("style", "display:none;");
		document.getElementById('moonButton').setAttribute ("style", "display:none;");
	
		document.getElementById('footer').setAttribute ("style", "background-image:url(Images/borderBottomNoTabs.png);");

		//infoDiv.style.overflow = "hidden";
		//alert("setupInfoAnimation - entering: hiding");
	}
	else {
		document.getElementById('footer').setAttribute ("style", "background-image:url(Images/borderBottom.png);");
	}

	resizeAnimation.element = infoDiv;
	if (resizeAnimation.timer != null) // it is moving... change to new size
	{
		clearInterval(resizeAnimation.timer);
		resizeAnimation.timer = null;
		resizeAnimation.duration -= (timeNow - resizeAnimation.startTime);
		resizeAnimation.positionFrom = resizeAnimation.positionNow;
	}
	else
	{
		resizeAnimation.duration = 250 * multiplier;
		resizeAnimation.positionFrom = startingSize;
	}
	
	if (window.widget && !hiding)
	{
		window.resizeTo (widgetWidth, calculateWidgetHeight());
	}
	resizeAnimation.positionTo = hiding ? 0 : infoHeight;
	resizeAnimation.startTime = timeNow - 13; // set it back one frame.
	resizeAnimation.onfinished = hiding ? animHidingFinished : animShowingFinished;
	
	resizeAnimation.element.style.height = startingSize;
	resizeAnimation.timer = setInterval ("animate();", 13);
	animate();
	
	/*
	if (hiding)
		alert("setupInfoAnimation - leaving: hiding");
	else
		alert("setupInfoAnimation - leaving: showing");
	*/
}

function switchToSunDiv(event)
{
	if (infoMode != 'sun')
	{
		showSunDiv();

		infoMode = 'sun';
		if (window.widget)
			setPreferenceForKey(infoMode, infoModePrefKey);
	}
}

function showSunDiv()
{
	document.getElementById('tabBorder').src = "Images/sunSelected.png";

	document.getElementById('sunButton').setAttribute ("style", "opacity:1.0;");
	document.getElementById('timeButton').setAttribute ("style", "opacity:0.5;");
	document.getElementById('moonButton').setAttribute ("style", "opacity:0.5;");

	document.getElementById('sunDiv').setAttribute ("style", "display:inline-block;");
	document.getElementById('timeDiv').setAttribute ("style", "display:none;");
	document.getElementById('moonDiv').setAttribute ("style", "display:none;");
}

//pre-fetch images
//(new Image()).src = "Images/infoMoon.png";
//(new Image()).src = "Images/infoTime.png";

function switchToMoonDiv(event)
{
	if (infoMode != 'moon')
	{
		showMoonDiv();

		infoMode = 'moon';
		if (window.widget)
			setPreferenceForKey(infoMode, infoModePrefKey);
	}
}

function showMoonDiv()
{
	document.getElementById('tabBorder').src = "Images/moonSelected.png";

	document.getElementById('sunButton').setAttribute ("style", "opacity:0.5;");
	document.getElementById('timeButton').setAttribute ("style", "opacity:0.5;");
	document.getElementById('moonButton').setAttribute ("style", "opacity:1.0;");

	document.getElementById('sunDiv').setAttribute ("style", "display:none;");
	document.getElementById('timeDiv').setAttribute ("style", "display:none;");
	document.getElementById('moonDiv').setAttribute ("style", "display:inline-block;");
}

function switchToTimeDiv(event)
{
	if (infoMode != 'time')
	{
		showTimeDiv();

		infoMode = 'time';
		if (window.widget)
			setPreferenceForKey(infoMode, infoModePrefKey);
	}
}

function showTimeDiv()
{
	document.getElementById('tabBorder').src = "Images/timeSelected.png";

	document.getElementById('sunButton').setAttribute ("style", "opacity:0.5;");
	document.getElementById('timeButton').setAttribute ("style", "opacity:1.0;");
	document.getElementById('moonButton').setAttribute ("style", "opacity:0.5;");

	document.getElementById('sunDiv').setAttribute ("style", "display:none;");
	document.getElementById('timeDiv').setAttribute ("style", "display:inline-block;");
	document.getElementById('moonDiv').setAttribute ("style", "display:none;");
}


function updateInfo()
{
	//alert("js-updateInfo: showingInfo = " + showingInfo);

	if (!showingInfo || currentSelection == null)
		return;
	
	var count = placeTimes.length;
	var found = false;
	for (var index = 0; index < count; ++index)
	{
		if (placeTimes[index] == currentSelection.placeTimeID)
		{
			found = true;
			break;
		}
	}
	
	//alert("js-updateInfo: index = " + index);

	if (!found)
	{
		alert("js-updateInfo: !found");
		document.getElementById("currentLight").innerText = "";
		document.getElementById("daylightDuration").innerText = "";
	}
	else
	{
		//sun
		document.getElementById("currentLightTitle").innerText = VTPlugin.infoStringForRow(19, index);
		document.getElementById("currentLight").innerText = VTPlugin.infoStringForRow(20, index);
		
		//var earthLight = currentSelection.earthLight;
		var earthLight = VTPlugin.earthLightKindForRow(index);
		//alert("updateInfo: earthLight = " + earthLight);
		document.getElementById('lightDot').src = getEarthLightImage(earthLight);

		var timeInfo = VTPlugin.timeInfoForRow(index);
		document.getElementById('timePt-Image').style.left = (timeInfo[3]).toString() + "px";

		//time labels
		if (showAMPM) {
			document.getElementById("time03").innerText = "3a";
			document.getElementById("time06").innerText = "6a";
			document.getElementById("time09").innerText = "9a";
			document.getElementById("time12").innerText = "12p";
			document.getElementById("time15").innerText = "3p";
			document.getElementById("time18").innerText = "6p";
			document.getElementById("time21").innerText = "9p";
		} else {
			document.getElementById("time03").innerText = "3";
			document.getElementById("time06").innerText = "6";
			document.getElementById("time09").innerText = "9";
			document.getElementById("time12").innerText = "12";
			document.getElementById("time15").innerText = "15";
			document.getElementById("time18").innerText = "18";
			document.getElementById("time21").innerText = "21";
		}

		document.getElementById('daylight-Image').src = VTPlugin.imagePathForRow(1, index);
		document.getElementById("daylightDuration").innerText = VTPlugin.infoStringForRow(21, index);

		//time
		document.getElementById("localDate").innerText = VTPlugin.infoStringForRow(7, index);
		document.getElementById("relativeTime").innerText = VTPlugin.infoStringForRow(10, index);
		document.getElementById("tzAbbr").innerText = VTPlugin.infoStringForRow(12, index);
		document.getElementById("utcOffset").innerText = VTPlugin.infoStringForRow(11, index);

		//moon
		var phases = VTPlugin.phaseInfoForRow(index);
		
		var prevPhase = phases[0];
		var curPhase = phases[1];
		var nextPhase = phases[2];

		//updatePrevNextPhase(true, prevPhase[0]);
		
		//phase times
		if (showAMPM) {
			document.getElementById("prevPhaseTime").innerText = prevPhase[2][1];
			//document.getElementById("curPhaseTime").innerText = "1:11 AM";
			//document.getElementById("curPhaseTime").innerText = curPhase[2][1];
			document.getElementById("nextPhaseTime").innerText = nextPhase[2][1];
		} else {
			document.getElementById("prevPhaseTime").innerText = prevPhase[2][0];
			//document.getElementById("curPhaseTime").innerText = "1:11";
			//document.getElementById("curPhaseTime").innerText = curPhase[2][0];
			document.getElementById("nextPhaseTime").innerText = nextPhase[2][0];
		}

		//prev
		document.getElementById("prevPhase").innerText = prevPhase[0][1];
		document.getElementById("prevPhaseDate").innerText = prevPhase[1][0];
		
		document.getElementById("curPhase").innerText = curPhase[0][1];
		
		//updatePrevNextPhase(false, nextPhase[0]);
		document.getElementById("nextPhase").innerText = nextPhase[0][1];
		document.getElementById("nextPhaseDate").innerText = nextPhase[1][0];
		
		if (demoMode) {
			document.getElementById('curPhase-Image').src = "Images/demo_curP.png";
			document.getElementById('prevPhase-Image').src = "Images/demo_prevP.png";
			document.getElementById('nextPhase-Image').src = "Images/demo_nextP.png";
		} else {
			document.getElementById('curPhase-Image').src = VTPlugin.imagePathForRow(10, index);
			document.getElementById('prevPhase-Image').src = VTPlugin.imagePathForRow(11, index);
			document.getElementById('nextPhase-Image').src = VTPlugin.imagePathForRow(12, index);
		}
	}
}

function clickonrow (event, row)
{
	var oldSelection = currentSelection;
	
	if (currentSelection != null && row == currentSelection)
	{
		document.getElementById("selection").style.display = "none";
		currentSelection = null;
		
		if (window.VTPlugin)
			VTPlugin.setSelectedRowForID("none");
		if (window.widget)
			setPreferenceForKey("none", selectionPrefKey);
	
		setupInfoAnimation (true);
		showingInfo = false;
	}
	else
	{
		clickonrowimp(row);
		
		if (window.widget && oldSelection != currentSelection)
		{
			//write out the selection
			if (window.VTPlugin)
				VTPlugin.setSelectedRowForID(row.placeTimeID);
			setPreferenceForKey(row.placeTimeID, selectionPrefKey);
		}
		
		if (oldSelection == null)
		{
			showingInfo = true;
			setupInfoAnimation (false);
		}
	}
}

function clickonTime (event, node)
{
	//var row = node.parentNode;
	//alert("clickonTime: row.placeTimeID = " + row.placeTimeID);
	//alert("clickonTime: event = " + event);
	//alert("clickonTime: window.event = " + window.event);

	
	//if (event.altKey)
	//	alert ("clickonTime: option key is down");
	//else
	//	alert ("clickonTime: option key is up");

	showAMPM = !showAMPM;

	var foundSelection = false;
	var selectionIndex = 0;
	var header = document.getElementById('placesHeader');

	for (var index = 0; index < placeTimes.length; ++index)
	{
		var row = header.childNodes[index];				
		var savedEarthLight = row.earthLight;

		var placeTimeID = placeTimes[index];
		var time24Span = document.getElementById(placeTimeID+"_time24");
		var time12Span = document.getElementById(placeTimeID+"_time12");
		var timeAMPMSpan = document.getElementById(placeTimeID+"_timeAMPM");
		var digTimeBackground = document[placeTimeID+"_digTimeBack"];

		if (showAMPM) {
			if (savedEarthLight == 1)
				digTimeBackground.src = "Images/digTime12_1.png";
			else
				digTimeBackground.src = "Images/digTime12_5.png";
			digTimeBackground.setAttribute("style", "left: 177px;");

			time24Span.setAttribute ("style", "display:none;");
			time12Span.setAttribute ("style", "display:inline-block;");
			timeAMPMSpan.setAttribute ("style", "display:inline-block;");
		} else {
			if (savedEarthLight == 1)
				digTimeBackground.src = "Images/digTime24_1.png";
			else
				digTimeBackground.src = "Images/digTime24_5.png";
			digTimeBackground.setAttribute("style", "left: 195px;");
		
			time24Span.setAttribute ("style", "display:inline-block;");
			time12Span.setAttribute ("style", "display:none;");
			timeAMPMSpan.setAttribute ("style", "display:none;");
		}

		//find index of selected row
		if (currentSelection != null && placeTimes[index] == currentSelection.placeTimeID)
		{
			selectionIndex = index;
			foundSelection = true;
		}
	}	


	// change sun and moon time formats
	if (foundSelection) {
		var phases = VTPlugin.phaseInfoForRow(selectionIndex);
		var prevPhase = phases[0];
		var curPhase = phases[1];
		var nextPhase = phases[2];
	
		//times
		if (showAMPM) {
			document.getElementById("time03").innerText = "3a";
			document.getElementById("time06").innerText = "6a";
			document.getElementById("time09").innerText = "9a";
			document.getElementById("time12").innerText = "12p";
			document.getElementById("time15").innerText = "3p";
			document.getElementById("time18").innerText = "6p";
			document.getElementById("time21").innerText = "9p";

			document.getElementById("prevPhaseTime").innerText = prevPhase[2][1];
			//document.getElementById("curPhaseTime").innerText = "1:11 AM";
			//document.getElementById("curPhaseTime").innerText = curPhase[2][1];
			document.getElementById("nextPhaseTime").innerText = nextPhase[2][1];
		} else {
			document.getElementById("time03").innerText = "3";
			document.getElementById("time06").innerText = "6";
			document.getElementById("time09").innerText = "9";
			document.getElementById("time12").innerText = "12";
			document.getElementById("time15").innerText = "15";
			document.getElementById("time18").innerText = "18";
			document.getElementById("time21").innerText = "21";

			document.getElementById("prevPhaseTime").innerText = prevPhase[2][0];
			//document.getElementById("curPhaseTime").innerText = "1:11";
			//document.getElementById("curPhaseTime").innerText = curPhase[2][0];
			document.getElementById("nextPhaseTime").innerText = nextPhase[2][0];
		}
	}

	// set preference
	if (window.widget)
		setPreferenceForKey(showAMPM, showAMPMPrefKey);

	
	// stop proagation otherwise the clickonrow handler would be called
	event.stopPropagation();
	event.preventDefault();
}


function onshow ()
{
	if (window.VTPlugin)
		VTPlugin.onShow();
}

function onhide ()
{
	if (window.VTPlugin)
		VTPlugin.onHide();
}

document.addEventListener("keypress", keyPressed, true);


function keyPressed(e) {
	
	var movedSelection = false;
	var changedInfo = false;
	
	var selection = currentSelection;
	switch (e.charCode)
	{
		case 63232: // up
			movedSelection = true;
			selection = selection.previousSibling;
			if (selection == null)
			{
				selection = document.getElementById('placesHeader').lastChild;
			}
			break;
			
		case 63233: // down
			movedSelection = true;
			selection = selection.nextSibling;
			if (selection == null)
			{
				selection = document.getElementById('placesHeader').firstChild;
			}
			break;
			
		case 63235: // right
			if (showingInfo) {
				changedInfo = true;
				switch (infoMode)
				{
					case 'sun':
						switchToMoonDiv(e);
						break;
					case 'moon':
						switchToTimeDiv(e);
						break;
					case 'time':
						switchToSunDiv(e);
						break;
				}
			}
			break;

		case 63234: // left
			if (showingInfo) {
				changedInfo = true;
				switch (infoMode)
				{
					case 'time':
						switchToMoonDiv(e);
						break;
					case 'moon':
						switchToSunDiv(e);
						break;
					case 'sun':
						switchToTimeDiv(e);
						break;
				}
			}
			break;

		default:
			movedSelection = false;
			changedInfo = false;
			break;
	}
	
	
	if (movedSelection || changedInfo)
	{
		if (movedSelection)
			clickonrow (e, selection);
	
		if (changedInfo)
			updateInfo();
	
		e.stopPropagation();
		e.preventDefault();
	}
}

function setupMainTable(addPlacesToBackside)
{
	var count = placeTimes.length;
	var container = document.getElementById('placesHeader');
	removeAllChildren(container);		

	for (var index=0; index<count; ++index)
	{
		var row = createRow (index);
		container.appendChild (row);
		if (addPlacesToBackside)
			addPlace (index);
	}
	
	//set the bottom of table to correct class
	if (count < 2) count = 2;
	document.getElementById('tableBottom').setAttribute ("class", (count%2) != 0 ? "tableBottomDark" : "tableBottomLight");
	
	// fill in the backgorund
	container = document.getElementById('tableContainer');
	removeAllChildren(container);		

	count = count - 2;
	var light = true;
	for (var index = 0; index < count; ++index)
	{
		var div = document.createElement ('div');
		div.setAttribute  ("class", light ? "tableRowLight" : "tableRowDark");
		container.appendChild (div);
		light = !light;
	}
}


function addClock(region, place)
{
	var placeTimeID = null;
	
	if (window.VTPlugin)
		placeTimeID = VTPlugin.addClock(region, place);
	
	if (placeTimeID != null)
		placeTimes[placeTimes.length] = placeTimeID;
	
	return placeTimeID;
}

var curRegionIndex = 1;
var curPlaceIndex = 9;

function setupClocks()
{
	// Add default clocks or get clocks from saved preferences.

	if (window.VTPlugin) {
		// the code is in control!
		var pluginMode = VTPlugin.initPlugin(widget.identifier);
		
		if (pluginMode == 0)
			demoMode = false;
		else if (pluginMode == 1)
			demoMode = true;
		else
			validMode = false;
		
		//alert("demoMode  = " + demoMode);
		//alert("validMode = " + validMode);

	} else {
		alert("setupClocks: VTPlugin NOT loaded");
	}

	var status = "widget failure";
	if (window.VTPlugin)
		status = VTPlugin.infoString(0);
	document.getElementById("version").innerText = status;
		
	var phaseDemo = document.getElementById('phaseDemo');
	if (demoMode)
		phaseDemo.setAttribute ("style", "visibility:visible;");
	else
		phaseDemo.setAttribute ("style", "visibility:hidden;");

	
	if (!validMode)
		return validMode;

	var savedPlaces;
	if (window.VTPlugin)
		savedPlaces = VTPlugin.readPlaceInfo();
	else
		savedPlaces = new Array();
	
	var placeCount = savedPlaces.length;		

	if (placeCount > 0) {

		for (var index = 0; index < placeCount; ++index)
		{
			placeTimes[placeTimes.length] = savedPlaces[index];
		}
		
	} else {
		addClock(1, 9);   //Cupertino
		VTPlugin.savePlaceInfo(true);
		//alert("js-setupClocks: savePlaceInfo");
	}
	
	return true;
}


function setupWidget()
{
	var selectedPlaceTimeID = null;
	
	if (window.widget)
	{
		//populateBacksideSelect();
		//document.getElementById ('content-backsideMenu').options[curBacksideItem].selected = true;

		var success = setupClocks();

		if (!success)
			return;
		
		try {
			selectedPlaceTimeID = getPreferenceForKey(selectionPrefKey, false);
			
			showAMPM = getPreferenceForKey(showAMPMPrefKey, false);
			if (showAMPM == null) {
				if (window.VTPlugin)
					showAMPM = VTPlugin.getShowAMPMSystem();
				else
					showAMPM = true;
			}

			infoMode = getPreferenceForKey(infoModePrefKey, false);
			if (infoMode == null)
				infoMode = 'sun';

			//curRegionIndex is initialized to 1 (North America)
			var regionIndexStr = getPreferenceForKey(regionPrefKey, false);
			if (regionIndexStr != null)
				curRegionIndex = parseInt(regionIndexStr);
			
			//curPlaceIndex is initialized to 9 (Cupertino)
			var placeIndexStr = getPreferenceForKey(placePrefKey, false);
			if (placeIndexStr != null)
				curPlaceIndex = parseInt(placeIndexStr);

			populateRegionSelect();
			document.getElementById ('region-dropDownMenu').options[curRegionIndex].selected = true;
			popuplateCitySelect();
			document.getElementById ('city-dropDownMenu').options[curPlaceIndex].selected = true;
		
		}
		catch(ex)
		{
			alert("starup error");
		}
	}


	// add all of our places to the widget
	setupMainTable (true);

	var header = document.getElementById('placesHeader');
	currentSelection = header.firstChild;
	if (selectedPlaceTimeID != null)
	{
		if (selectedPlaceTimeID == "none")
		{
			document.getElementById("selection").style.display = "none";
			currentSelection = null;
			showingInfo = false;
			document.getElementById('infoArea').style.height = "0";
		}
		else
		{
			for (var child = header.firstChild; child != null; child = child.nextSibling)
			{
				if (child.placeTimeID == selectedPlaceTimeID)
				{
					// no need to do anything if the first item is the one selected.
					if (currentSelection != child)
					{
						clickonrowimp (child);
					}
				}
			}
		}
	}

	//adjust position of selected state.
	if (currentSelection == header.firstChild)
		clickonrowimp (currentSelection);

	if (showingInfo) {
		switch (infoMode)
		{
			case 'sun':
				showSunDiv();
				break;
			case 'moon':
				showMoonDiv();
				break;
			case 'time':
				showTimeDiv();
				break;
		}
	} else {
		document.getElementById('sunButton').setAttribute ("style", "display:none;");
		document.getElementById('timeButton').setAttribute ("style", "display:none;");
		document.getElementById('moonButton').setAttribute ("style", "display:none;");
		
		document.getElementById('footer').setAttribute ("style", "background-image:url(Images/borderBottomNoTabs.png);");

		document.getElementById('sunDiv').setAttribute ("style", "display:none;");
		document.getElementById('timeDiv').setAttribute ("style", "display:none;");
		document.getElementById('moonDiv').setAttribute ("style", "display:none;");
	}
	
	
	// backside strings
	
	document.getElementById('citiesLabel').innerText = "Cities/Places:";
	//document.getElementById('demoText').innerHTML = "Demo";
	
	//document.getElementById("wTitle").innerText = "VelaClock";
	document.getElementById("creators").innerText = "Creators";
	document.getElementById("creator1").innerText = "Jennifer Goshay";
	document.getElementById("creator2").innerText = "Chuck Soper";
	document.getElementById("creator3").innerText = "Klaus Strelau";
	document.getElementById("role1").innerText = "Artist:";
	document.getElementById("role2").innerText = "Developers:";
	document.getElementById("role3").innerText = "";

	document.getElementById("credits").innerText = "Acknowledgments";
	document.getElementById("source1").innerText = "Astronomy on the Personal Computer";
	document.getElementById("source1TitleA").innerText = "Authors:";
	document.getElementById("source1DescA").innerText = "Oliver Montenbruck Thomas Pfleger";
	document.getElementById("source1TitleB").innerText = "Publisher:";
	document.getElementById("source1DescB").innerText = "Springer Verlag";
	document.getElementById("source1Desc").innerText = 'Thorough introduction to the computation of celestial mechanics.';
	document.getElementById("source1Perm").innerText = "Written permission was obtained from both authors and the publisher.";

	document.getElementById("source2").innerText = "Photo © UC Regents/Lick Observatory";
	document.getElementById("source2Desc").innerText = "Full moon photo was taken in the late 1930s with a 36-inch refracting telescope originally built in 1888.";
	document.getElementById("source2Link").innerText = "www.ucolick.org";
	document.getElementById("source2Perm").innerText = "Written permission was obtained from Lick Observatory. Unauthorized use prohibited.";

	document.getElementById("source3").innerText = "tz database";
	document.getElementById("source3Desc").innerText = "Public-domain time zone database.";
	
	document.getElementById("productName").innerText = "VelaClock";
	document.getElementById("productInfo").innerText = "Product Information";
	document.getElementById("companyName").innerText = "Copyright © 2005 Vela Design Group";
	document.getElementById("copyright").innerText = "All Rights Reserved";

	document.getElementById("regTitle").innerText = "Not Registered";


	//Add place button
	var addButton = document.getElementById('addPlace');
	createGenericButton (addButton, getLocalizedString('Add'), addButtonClicked, 67);
	enableAddButton();
	
	document.getElementById("addHint").innerText = "";

	//moveUp button
	var moveUpButton = document.getElementById('moveUp');
	createGenericButton (moveUpButton, getLocalizedString('↑'), moveUpClicked, 20);
	genericButtonSetEnabled (moveUpButton, false);
	
	//moveDown button
	var moveDownButton = document.getElementById('moveDown');
	createGenericButton (moveDownButton, getLocalizedString('↓'), moveDownClicked, 20);
	genericButtonSetEnabled (moveDownButton, false);

	//Remove place button
	var removeButton = document.getElementById('removePlace');
	createGenericButton (removeButton, getLocalizedString('Remove'), removeButtonClicked);
	genericButtonSetEnabled (removeButton, false);
	
	//Other button (for 'Purchase' or 'Send Feedback')
	var otherButton = document.getElementById('otherButton');
	var buttonTitle = demoMode ? 'Purchase' : 'Send Feedback'; //use getLocalizedString
	createGenericButton (otherButton, buttonTitle, purchaseButtonClicked);
	genericButtonSetEnabled (otherButton, true);
	

	//Done button
	var doneButton = document.getElementById('doneButton');
	createGenericButton (doneButton, getLocalizedString('Done'), selectDone, 67);
	
	onshow();
	
	//CFS
	updateNow(); //calls updateInfo


	//if (window.widget && !showingInfo)
	//if (window.widget && (placeTimes.length != 6 || !showingInfo))
	{
		window.resizeTo (widgetWidth, calculateWidgetHeight());
	}

}

// add the onhide and onshow callbacks
if (window.widget)
{
	widget.onhide = onhide;
	widget.onshow = onshow;
	widget.onremove = onremove;
}

/*
var contentList = [
	{menuItem:'Credits'},
	{menuItem:'Settings'},
	{menuItem:'Registration'}
];

function populateBacksideSelect()
{
	//alert("populateBacksideSelect: entering");

	var select = document.getElementById ('content-backsideMenu');

	//if (select.hasChildNodes())
	//	return;

	var menuItemCnt = contentList.length;
	
	for (var index = 0; index < menuItemCnt; ++index)
	{
		var element = document.createElement("option");
		element.innerText = contentList[index].menuItem;
		select.appendChild (element);
	}
}
*/

function showBackCreditsDiv()
{
	if (curBacksideItem != 0) {
		curBacksideItem = 0;
		changeBacksideContent();
		//document.getElementById ('content-backsideMenu').options[curBacksideItem].selected = true;
	}
}

function showBackSettingsDiv()
{
	if (curBacksideItem != 1) {
		curBacksideItem = 1;
		changeBacksideContent();
		//document.getElementById ('content-backsideMenu').options[curBacksideItem].selected = true;
	}
}

function showBackRegDiv()
{
	if (curBacksideItem != 2) {
		curBacksideItem = 2;
		changeBacksideContent();
		//document.getElementById ('content-backsideMenu').options[curBacksideItem].selected = true;
	}
}


function changeBacksideContent()
{
	if (curBacksideItem == 0) { //Credits
		document.getElementById('creditsDiv').setAttribute ("style", "display:inline-block;");
		document.getElementById('settingsDiv').setAttribute ("style", "display:none;");
		document.getElementById('regDiv').setAttribute ("style", "display:none;");

		document.getElementById('backTab1').src = "Images/backTab1.png";
		document.getElementById('backTab2').src = "Images/backTab2Un.png";
		document.getElementById('backTab3').src = "Images/backTab3Un.png";
	}
	
	else if (curBacksideItem == 2) { //Registration
		document.getElementById('creditsDiv').setAttribute ("style", "display:none;");
		document.getElementById('settingsDiv').setAttribute ("style", "display:none;");
		document.getElementById('regDiv').setAttribute ("style", "display:inline-block;");

		document.getElementById('backTab1').src = "Images/backTab1Un.png";
		document.getElementById('backTab2').src = "Images/backTab2Un.png";
		document.getElementById('backTab3').src = "Images/backTab3.png";
	}

	else { //Settings
		document.getElementById('creditsDiv').setAttribute ("style", "display:none;");
		document.getElementById('settingsDiv').setAttribute ("style", "display:inline-block;");
		document.getElementById('regDiv').setAttribute ("style", "display:none;");

		document.getElementById('backTab1').src = "Images/backTab1Un.png";
		document.getElementById('backTab2').src = "Images/backTab2.png";
		document.getElementById('backTab3').src = "Images/backTab3Un.png";
	}




}

function backsideContentChanged (select)
{
	if (curBacksideItem != select.selectedIndex)
	{
		curBacksideItem = select.selectedIndex;
		changeBacksideContent();
	}
}

function populateRegionSelect()
{
	//alert("populateRegionSelect: entering");

	if (window.VTPlugin) {
		var regionList = VTPlugin.regionList();

		var select = document.getElementById ('region-dropDownMenu');

		//if (select.hasChildNodes())
		//	return;

		var regionCnt = regionList.length;
		
		for (var index = 0; index < regionCnt; ++index)
		{
			var element = document.createElement("option");
			element.innerText = regionList[index];
			select.appendChild (element);
		}
	}
}

function popuplateCitySelect()
{
	if (window.VTPlugin) {
		var placeList = VTPlugin.placeListForRegion(curRegionIndex);

		var select = document.getElementById ('city-dropDownMenu');
		while (select.hasChildNodes())
			select.removeChild(select.firstChild);
		
		var placeCnt = placeList.length;
		
		for (var index = 0; index < placeCnt; ++index)
		{
			var element = document.createElement("option");
			element.innerText = placeList[index];
			//if (index == 1)
			//	element.innerText = placeList[index] + " [$]";
			//else
			//	element.innerText = placeList[index];
			select.appendChild (element);
		}
	}
}

function enableAddButton(notAvailable)
{
	var addButton = document.getElementById('addPlace');

	if (placeTimes.length == maxItems) {
		genericButtonSetEnabled (addButton, false);
		document.getElementById("addHint").innerText = "A maximum of 16 places may be added.";
		return;
	}

	var placeAlreadyExists = true;
	var addHintText = "";
	if (window.VTPlugin) {
		var addInfoArray = VTPlugin.addInfo(curRegionIndex, curPlaceIndex);
		placeAlreadyExists = addInfoArray[0];
		addHintText = addInfoArray[1];
	}
	
	document.getElementById("addHint").innerText = addHintText;
	genericButtonSetEnabled (addButton, !placeAlreadyExists);
}

function regionChanged (select)
{
	//alert("regionChanged: entering");
	if (curRegionIndex != select.selectedIndex)
	{
		curRegionIndex = select.selectedIndex;
		popuplateCitySelect();
		curPlaceIndex = 0;
	 	document.getElementById ('city-dropDownMenu').options[curPlaceIndex].selected = true;
	
		enableAddButton();
		
		if (window.widget) {
			setPreferenceForKey(curRegionIndex.toString(), regionPrefKey);
			setPreferenceForKey(curPlaceIndex.toString(), placePrefKey);
		}
	}
}

function cityChanged (select)
{
	//alert("cityChanged: entering");
	if (curPlaceIndex != select.selectedIndex)
	{
		curPlaceIndex = select.selectedIndex;
	 	
		enableAddButton();

		if (window.widget) {
			setPreferenceForKey(curRegionIndex.toString(), regionPrefKey);
			setPreferenceForKey(curPlaceIndex.toString(), placePrefKey);
		}
	}
}

var selectedRow=null;
function clickonbackrow(event, row)
{
	var moveUpButton = document.getElementById('moveUp');
	var moveDownButton = document.getElementById('moveDown');

	if (placeTimes.length > 1)
		genericButtonSetEnabled (document.getElementById('removePlace'), true);


	if (selectedRow == row && event != null && event.metaKey)
	{
		row.setAttribute("class", "row");
		selectedRow = null;
		genericButtonSetEnabled (moveUpButton, false);	
		genericButtonSetEnabled (moveDownButton, false);
		genericButtonSetEnabled (document.getElementById('removePlace'), false);
	}
	
	else if (selectedRow != row)
	{
		if (selectedRow != null)
			selectedRow.setAttribute("class", "row");
		selectedRow = row;
		
		var index;
		var found = false;
		var count = placeTimes.length;
		for (index = 0; index < count; ++index)
		{
			if (placeTimes[index] == row.placeTimeID)
			{
				found = true;
				break;
			}
		}

		genericButtonSetEnabled (moveUpButton, index != 0);	
		genericButtonSetEnabled (moveDownButton, index != count-1);

		//alert("backRow: index = " + index + " placeTimeID = " + row.placeTimeID);
		
		row.setAttribute ("class", "row select");
	}	
	
	if (event)
	{
		event.stopPropagation();
		event.preventDefault();
	}
}

var lastValidPlaceTimeID = null;


function placeAlreadyInSet(placeTimeID)
{
	var count = placeTimes.length;
	
	for (var index = 0; index < count; ++index)
	{
		if (placeTimes[index] == placeTimeID)
			return index;
	}

	return -1;
}

function addOrSelectItem ()
{
	var index = placeAlreadyInSet(lastValidPlaceTimeID);
	if (index < 0)
	{
		// make sure we have the correct number of items
		if (placeTimes.length < maxItems)
		{		
			index = placeTimes.length;
			var placeTimeID = addClock(curRegionIndex, curPlaceIndex); 
			if (placeTimeID != null) {
				if (window.VTPlugin)
					VTPlugin.savePlaceInfo(true);
				
				var row = addPlace (index);
				
				backsideChanged = true;
				
				clickonbackrow (null, row);
				if (placeTimes.length == maxItems)
					enableAddButton();
			}
		}
	}
	else
	{
		// select the item that is already there.
		var row = document.getElementById('inner-list').firstChild;
		for (var i = 0; index < index; ++index)
			row = row.nextSibling;
			
		if (row != null) // just to be safe, should never happen
		{
			clickonbackrow (null, row);
		}
	}
}


function findIndexOfChild (child)
{
	var node = child.parentNode;
	
	var index = 0;
	
	for (node = node.firstChild; node != null; node = node.nextSibling, ++index)
	{
		if (node == child)
			return index;
	}
	
	return -1;
}

function removeAllChildren (parent)
{
	while (parent.hasChildNodes())
		parent.removeChild(parent.firstChild);
}

function addButtonClicked ()
{
	//alert("addButtonClicked: region = " + curRegionIndex + " place = " + curPlaceIndex);
	
	lastValidPlaceTimeID = VTPlugin.generatePlaceTimeID(curRegionIndex, curPlaceIndex);
	
	//alert("addButtonClicked: lastValidPlaceTimeID = " + lastValidPlaceTimeID);
	
	//CFS: call and fix this function!
	addOrSelectItem();

	enableAddButton();
}

function moveUpClicked ()
{
	if (selectedRow != null)
	{
		var index = findIndexOfChild (selectedRow);
		if (index <= 1)
			genericButtonSetEnabled (document.getElementById('moveUp'), false);
		
		genericButtonSetEnabled (document.getElementById('moveDown'), true);

		var parentNode = selectedRow.parentNode;
		var prevSib = selectedRow.previousSibling;
		
		parentNode.insertBefore(selectedRow, prevSib);
		
		var idToMove = placeTimes[index];
		placeTimes[index] = placeTimes[index-1];
		placeTimes[index-1] = idToMove;
		
		//reorder placeTimes array
		VTPlugin.exchangePlaceTimes(index, index-1);
		
		backsideChanged = true;
	}
}

function moveDownClicked ()
{
	if (selectedRow != null)
	{
		var index = findIndexOfChild (selectedRow);
		if (index >= (placeTimes.length-2))
			genericButtonSetEnabled (document.getElementById('moveDown'), false);

		genericButtonSetEnabled (document.getElementById('moveUp'), true);

		var parentNode = selectedRow.parentNode;
		var nextSib = selectedRow.nextSibling;
		
		parentNode.insertBefore(nextSib, selectedRow);
		
		var idToMove = placeTimes[index];
		placeTimes[index] = placeTimes[index+1];
		placeTimes[index+1] = idToMove;
		
		//reorder placeTimes array
		VTPlugin.exchangePlaceTimes(index, index+1);
		
		backsideChanged = true;
	}
}


function removeButtonClicked ()
{
	if (selectedRow != null)
	{
		var index = findIndexOfChild (selectedRow);
		var parentNode = selectedRow.parentNode;
		
		placeTimes.splice (index, 1);

		if (window.VTPlugin) {
			VTPlugin.removePlaceTime(index);
			VTPlugin.savePlaceInfo(true);
			//alert("js-removeButtonClicked: savePlaceInfo");
		}
		
		parentNode.removeChild(selectedRow);

		selectedRow = null;
		if (placeTimes.length > 1)
		{
			if (index >= placeTimes.length)
				index = placeTimes.length-1;
			
			var nextSelection = parentNode.firstChild;
			for (var index=0; index<index;++index)
				nextSelection = nextSelection.nextSibling;
			
			if (nextSelection != null) {
				clickonbackrow (null, nextSelection);
				genericButtonSetEnabled (document.getElementById('removePlace'), true);
			}

		}
		else
		{
			genericButtonSetEnabled (document.getElementById('removePlace'), false);
		}
		
		enableAddButton();
		
		backsideChanged = true;
	}
}

/*
function setDemoMode(mode)
{
	demoMode = mode;
	if (!demoMode) {
		popuplateCitySelect();
		document.getElementById("regTitle").innerText = "Serial Number"
		document.getElementById("regDesc1").innerText = VTPlugin.sNum();
		document.getElementById("regDesc2").innerText = "";
		document.getElementById("regDesc3").innerText = "";
		enableAddButton();
	}
}
*/

function purchaseButtonClicked()
{
	//alert("purchaseButtonClicked");
	if (demoMode) {
		//if (window.VTPlugin)
		//	VTPlugin.purchaseStarted();
		widget.openApplication("com.veladg.VelaReg");
	} else {
		widget.openURL("http://www.veladg.com/feedback.html?p=VelaClock");
	}
}

function addPlace (index)
{
	var innerList = document.getElementById('inner-list');
	
	var row = document.createElement('div');
	row.setAttribute("class", "row");
	row.setAttribute("onclick", "clickonbackrow(event, this);");
	
	var span = document.createElement('span');
	span.setAttribute ("class", "placesColumn");
	if (index < 0) {
		span.innerText = "unknown";
	} else {
		span.innerText = VTPlugin.infoStringForRow(0, index);
		row.setAttribute ("placeTimeID", placeTimes[index]);
	}
	row.appendChild(span);
	
	innerList.appendChild(row);
	
	return row;
}

/*
function clickonDemoMode (event)
{
	demoMode = !demoMode;
	
	var demoState = demoMode ? "true" : "false";
	//alert("clickonDemoMode: demoMode = " + demoState);

	var checkBoxElement = document.getElementById('demoCheckbox');	
	checkBoxElement.checked = demoMode;

	// set the preference?
	
	// stop proagation
	event.stopPropagation();
}
*/

function clickLickObs(event)
{
	if (widget)
		widget.openURL("http://www.ucolick.org/");
}

function clickLogo(event)
{
	if (widget) {
		if (demoMode)
			widget.openURL("http://www.veladg.com/velaclockDemo.html");
		else
			widget.openURL("http://www.veladg.com/velaclock.html");
	}
}

function calculateWidgetHeight ()
{
	var height = 31 + // 34 row 1 (table top)
	             28 + // 29 row N (table bottom)
	             30;  // 24 28 35 footer
	
	if (showingInfo) {
		height += 5; //taller borderBottom (shorter borderBottomNoTabs)
		height += infoHeight;
	}
		
	var count = placeTimes.length - 2;
	
	if (count > 0)
		height += (count * 25); // 25 row height
	
	//alert("calculateWidgetHeight = " + height);

	return height;
}

function onremove ()
{
	if (window.VTPlugin)
		VTPlugin.onRemove();

	// remove all the pref keys here
	if (window.widget) {
		setPreferenceForKey(null, selectionPrefKey);
		setPreferenceForKey(null, showAMPMPrefKey);
		setPreferenceForKey(null, infoModePrefKey);
		setPreferenceForKey(null, regionPrefKey);
		setPreferenceForKey(null, placePrefKey);
	}
}

function createKey (key)
{
	return widget.identifier + "-" + key;
}

function setPreferenceForKey(pref, key)
{
	//set pref for widget instance
	widget.setPreferenceForKey(pref, createKey(key));
	
	//consider setting global pref
	//widget.setPreferenceForKey(pref, key);
}

function getPreferenceForKey (key, global)
{
	//get pref for widget instance
	var pref = widget.preferenceForKey(createKey(key));
	
	//consider getting global pref
	//if (pref == null && global)
	//	pref = widget.preferenceForKey(key);
	
	return pref;
}

var resizeAnimation = {startTime:0, duration:250, positionFrom:0, positionTo:0, positionNow:0, timer:null, element:null, onfinished:null};


function limit_3 (a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

function animate () {
	var T;
	var ease;
	var time  = (new Date).getTime();
	var yLoc;
	var frame;
		
	T = limit_3(time-resizeAnimation.startTime, 0, resizeAnimation.duration);
	ease = 0.5 - (0.5 * Math.cos(Math.PI * T / resizeAnimation.duration));

	if (T >= resizeAnimation.duration)
	{
		yLoc = resizeAnimation.positionTo;
		clearInterval (resizeAnimation.timer);
		resizeAnimation.timer = null;
		
		if (resizeAnimation.onfinished)
			setTimeout ("resizeAnimation.onfinished();", 0); // call after the last frame is drawn
	}
	else
		yLoc = computeNextFloat(resizeAnimation.positionFrom, resizeAnimation.positionTo, ease);
		
	// convert to a integer, not sure if this is the best way
	resizeAnimation.positionNow = parseInt(yLoc);
	resizeAnimation.element.style.height = resizeAnimation.positionNow + "px";
}

function animHidingFinished()
{
	if (window.widget)
	{
		window.resizeTo (widgetWidth, calculateWidgetHeight());
		//alert("animHidingFinished: info hidden");
	}
}


function animShowingFinished()
{
	//show the tabs
	document.getElementById('sunButton').setAttribute ("style", "display:inline-block;");
	document.getElementById('timeButton').setAttribute ("style", "display:inline-block;");
	document.getElementById('moonButton').setAttribute ("style", "display:inline-block;");

	//Note: the opacity of the tabs can't be changed if "display:none;"
	
	//unhighlight all tabs
	document.getElementById('sunButton').setAttribute ("style", "opacity:0.5;");
	document.getElementById('timeButton').setAttribute ("style", "opacity:0.5;");
	document.getElementById('moonButton').setAttribute ("style", "opacity:0.5;");
	
	//highlight the selected tab
	if (infoMode == 'time')
		document.getElementById('timeButton').setAttribute ("style", "opacity:1.0;");
	else if (infoMode == 'moon')
		document.getElementById('moonButton').setAttribute ("style", "opacity:1.0;");
	else
		document.getElementById('sunButton').setAttribute ("style", "opacity:1.0;");
	
	//document.getElementById('infoArea').style.overflow = "visible";
	//alert("animShowingFinished: info showing");
}


var flipAnimation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, element:null, timer:null};
var flipShown = false;
function flipAnimate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-flipAnimation.starttime, 0, flipAnimation.duration);
	
	if (T >= flipAnimation.duration)
	{
		clearInterval (flipAnimation.timer);
		flipAnimation.timer = null;
		flipAnimation.now = flipAnimation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / flipAnimation.duration));
		flipAnimation.now = computeNextFloat (flipAnimation.from, flipAnimation.to, ease);
	}
	
	flipAnimation.element.style.opacity = flipAnimation.now;
}

function mousemove (event)
{
	if (!flipShown)
	{
		// fade in the flip widget
		if (flipAnimation.timer != null)
		{
			clearInterval (flipAnimation.timer);
			flipAnimation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		flipAnimation.duration = 500;
		flipAnimation.starttime = starttime;
		flipAnimation.element = document.getElementById ('flip');
		flipAnimation.timer = setInterval ("flipAnimate();", 13);
		flipAnimation.from = flipAnimation.now;
		flipAnimation.to = 1.0;
		flipAnimate();
		flipShown = true;
	}
}

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (flipAnimation.timer != null)
		{
			clearInterval (flipAnimation.timer);
			flipAnimation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		flipAnimation.duration = 500;
		flipAnimation.starttime = starttime;
		flipAnimation.element = document.getElementById ('flip');
		flipAnimation.timer = setInterval ("flipAnimate();", 13);
		flipAnimation.from = flipAnimation.now;
		flipAnimation.to = 0.0;
		flipAnimate();
		flipShown = false;
	}
}
